# 判断

Goods 数据库中有一个名为 trade 的存储过程，封装了交易过程，每一笔交易，trade都会被调用一次。Joe 
想在 trade 里加一段逻辑，实现：

1. 每一次交易，对 @counter 变量加一
2. 如果 @counter 是 1000 的整倍数，就将 @total_price 变量乘 0.8。

下面哪一段代码可以实现这个逻辑？

## 答案

```mysql
set @counter = @counter + 1;
if @counter % 1000 = 0 then
    set @total_price = @total_price * 0.8;
end if;
```

## 选项

### A

```mysql
set @counter = @counter + 1;
if @counter % 1000 = 0 {
    set @total_price = @total_price * 0.8;
}
```

### B

```mysql
set @counter = @counter + 1;
if (@counter % 1000 = 0) {
    set @total_price = @total_price * 0.8;
}
```

### C

```mysql
if @counter % 1000 = 0 begin ;
    set @total_price = @total_price * 0.8;
end;
```

### D

```mysql
set @counter ++;
if @counter % 1000 = 0 then begin 
    select @total_price = @total_price * 0.8;
end;
```